import * as types from "./types";
import axios from "axios";
import url from "../../BackendURL.js";

//login admin
export const adminLogin = (data) => async (dispatch) => {
  try {
    dispatch({ type: types.LOGIN_ADMIN_REQUEST });

    const res = await axios.post(`${url}/admin/login`, {
      email: data.email,
      password: data.password,
    });

    dispatch({
      type: types.LOGIN_ADMIN_SUCCESS,
      payload: {
        message: res.data.message,
        user: res.data.user,
        token: res.data.token,
      },
    });

    return res.data;
  } catch (error) {
    dispatch({
      type: types.LOGIN_ADMIN_ERROR,
      payload: {
        message: "error",
      },
    });
  }
};

//login tutor
export const tutorLogin = (data) => async (dispatch) => {
  try {
    dispatch({ type: types.LOGIN_TUTOR_REQUEST });

    const res = await axios.post(`${url}/tutor/login`, {
      email: data.email,
      password: data.password,
    });

    dispatch({
      type: types.LOGIN_TUTOR_SUCCESS,
      payload: {
        message: res.data.message,
        user: res.data.user,
        token: res.data.token,
      },
    });

    return res.data;
  } catch (error) {
    dispatch({
      type: types.LOGIN_TUTOR_ERROR,
      payload: {
        message: "error",
      },
    });
  }
};

//login student
export const studentLogin = (data) => async (dispatch) => {
  try {
    dispatch({ type: types.LOGIN_STUDENT_REQUEST });

    const res = await axios.post(`${url}/student/login`, {
      email: data.email,
      password: data.password,
    });

    dispatch({
      type: types.LOGIN_STUDENT_SUCCESS,
      payload: {
        message: res.data.message,
        user: res.data.user,
        token: res.data.token,
      },
    });

    return res.data;
  } catch (error) {
    dispatch({
      type: types.LOGIN_STUDENT_ERROR,
      payload: {
        message: "error",
      },
    });
  }
};

// logout user
export const authLogout = () => async (dispatch) => {
  try {
    dispatch({
      type: types.AUTH_LOGOUT,
    });
  } catch (error) {
    console.log(error);
  }
};
